<?php

use App\Http\Controllers\Core\LanguageController;
use App\Http\Controllers\InstallDemoDataController;
use Illuminate\Support\Facades\Route;

Route::redirect('/', url('admin/users/login'));

/*
 * for documentation purpose
 */

Route::group(['middleware' => ['auth', 'authorize', 'app.installed']], function () {
    //
});

Route::view('/test','test')->name('test');

// Switch between the included languages
Route::get('lang/{lang}', [LanguageController::class, 'swap'])->name('language.change');

/*
 * All login related route will be go there
 * Only guest user can access this route
 */

Route::group(['middleware' => ['guest', 'app.installed'], 'prefix' => 'users'], function () {
    include_route_files(__DIR__ . '/user/');
});

Route::group(['middleware' => ['guest', 'app.installed'], 'prefix' => 'admin/users'], function () {
    include_route_files(__DIR__ . '/login/');
});

/**
 * This route is only for brand redirection
 * And for some additional route
 */
Route::group(['prefix' => 'admin', 'middleware' => ['auth', 'authorize', 'app.installed']], function () {
    include __DIR__ . '/additional.php';
});

Route::group(['middleware' => ['auth', 'authorize', 'app.installed'], 'prefix' => 'application-api'], function () {
    include_route_files(__DIR__ . '/application/');
});


Route::group(['middleware' => ['auth', 'authorize', 'app.installed'], 'prefix' => 'ai'], function () {
    include_route_files(__DIR__ . '/ai/');
});

/**
 * Backend Routes
 * Namespaces indicate folder structure
 * All your route in sub file must have a name with not more than 2 index
 * Example: brand.index or dashboard
 * See @var PermissionMiddleware for more information
 */
Route::group(['prefix' => 'admin', 'middleware' => ['admin', 'app.installed'], 'as' => 'core.'], function () {

    /*
     * (good if you want to allow more than one group in the core,
     * then limit the core features by different roles or permissions)
     *
     * Note: Administrator has all permissions so you do not have to specify the administrator role everywhere.
     * These routes can not be hit if the password is expired
     */
    include_route_files(__DIR__ . '/core/');
});

Route::group(['middleware' => ['app.installed']], function () {
    //Admin Route Here
    include_route_files(__DIR__ . '/admin/');
    Route::any('install-demo-data', [InstallDemoDataController::class, 'run'])
        ->name('install-demo-data');
});
