<?php

use App\Http\Controllers\Core\Auth\User\PasswordResetController;
use App\Http\Controllers\Core\Auth\UserConfirmController;
use App\Http\Controllers\Core\Auth\UserRegistrationController;
use Illuminate\Support\Facades\Route;

Route::get('confirm', [ UserConfirmController::class, 'index' ])
    ->name('user-invite.index')
    ->middleware('signed');

Route::post('confirm', [ UserConfirmController::class, 'confirm' ])
    ->name('user-invite.confirm');

Route::get('password-reset', [ PasswordResetController::class, 'index' ])
    ->name('password-reset.index');
Route::post('password-reset', [ PasswordResetController::class, 'store' ])
    ->name('password-reset.store');

Route::get('reset-password', [ PasswordResetController::class, 'show' ])
    ->name('reset-password.index')
    ->middleware('signed');

Route::post('reset-password', [PasswordResetController::class, 'update'])
    ->name('reset-password.store');

//registration routes
Route::get('registration', [UserRegistrationController::class, 'index'])->name('user-registration.index');
Route::post('registration', [UserRegistrationController::class, 'store'])->name('user-registration.store');
Route::get('email/verify', [ UserRegistrationController::class, 'confirm' ])
    ->name('email-verify.confirm')
    ->middleware('signed');
Route::get('email/verify/resent', [UserRegistrationController::class, 'showResentEmail'])->name('show-verify.index');
Route::post('email/verify/resent', [UserRegistrationController::class, 'resentVerifyEmail'])->name('resent-verify.index');