<?php

use App\Http\Controllers\Admin\AI\TemplateController;
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => 'template'], function () {
    Route::view('index', 'admin.template.index')->name('template.index');
    Route::get('list', [TemplateController::class, 'list'])->name('template.list');
    Route::get('generator/{template_slug}', [TemplateController::class, 'generatorForm'])->name('template.generator-form');
    Route::get('template-generator-data', [TemplateController::class, 'generatorData'])->name('template.generator-data');
    Route::get('favorite/get', [TemplateController::class, 'getFavorite'])->name('template.favorite.get');
    Route::post('favorite/add', [TemplateController::class, 'addFavorite'])->name('template.favorite.add');
});
