<?php

use App\Http\Controllers\Admin\AI\DocumentController;
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => 'document'], function () {
    Route::view('index', 'admin.document.index')->name('document.index');
    Route::get('list', [DocumentController::class, 'list'])->name('document.list');
    Route::post('store', [DocumentController::class, 'store'])->name('document.store');
    Route::get('find/{document_id}', [DocumentController::class, 'find'])->name('document.find');
    Route::post('update', [DocumentController::class, 'update'])->name('document.update');
    Route::delete('delete/{document_id}', [DocumentController::class, 'destroy'])->name('document.delete');
});
