<?php

use App\Http\Controllers\Admin\Setting\MailCheckController;
use App\Http\Controllers\Admin\Setting\TestMailController;
use Illuminate\Routing\Router;
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => '', 'middleware' => ['auth', 'authorize']], function (Router $router) {
    $router->get('app/check-mail-settings', MailCheckController::class)
        ->name('check-mail-settings');

    $router->post('app/test-mail/send', TestMailController::class)
        ->name('test-mail.send')
        ->middleware(['can:update_delivery_settings']);
});