<?php

use App\Http\Controllers\Admin\Setting\AiSettingController;
use App\Http\Controllers\Admin\Setting\BroadcastSettingController;
use App\Http\Controllers\Admin\Setting\GeneralSettingController;
use Illuminate\Support\Facades\Route;

Route::group(['middleware' => ['auth', 'authorize']], function () {
    Route::get('basic-general-setting', [GeneralSettingController::class, 'index'])->name('basic.general-setting');
    Route::get('general-settings', [GeneralSettingController::class, 'general'])->name('general.setting');

    Route::get('broadcast-setting', [BroadcastSettingController::class, 'index'])
        ->name('broadcast-setting');

    Route::post('broadcast-setting', [BroadcastSettingController::class, 'update'])
        ->name('setting-update');

    Route::get('ai-settings', [AiSettingController::class, 'index'])
        ->name('openai-setting');

    Route::post('ai-settings', [AiSettingController::class, 'update'])
        ->name('openai-update');
});