<?php

use App\Http\Controllers\Admin\Navigation\NavigationController;
use Illuminate\Support\Facades\Route;

Route::group(['middleware' => ['auth', 'authorize']], function () {

    Route::get('my-profile', [NavigationController::class, 'myProfile'])
        ->name('my-profile.view');

    Route::get('example-table-view', [NavigationController::class, 'exampleTable'])
        ->name('example-table.view');

    Route::get('users-and-roles', [NavigationController::class, 'viewUserAndRole'])
        ->name('user-and-role.view');

    Route::get('app-setting', [NavigationController::class, 'appSetting'])
        ->name('app-setting.view');

    Route::get('notification/list', [NavigationController::class, 'notificationList'])
        ->name('notification.view');

    Route::group(['prefix' => 'application'], function () {
        Route::get('teams', [NavigationController::class, 'teams'])
            ->name('teams.view');

        Route::get('report-types-view', [NavigationController::class, 'reportTypes'])->name('report-types-view.index');
        Route::get('reports', [NavigationController::class, 'reportsView'])->name('reports.view');
    });
});