<footer>
    <script>
        window.settings = <?php echo json_encode($settings) ?>
    </script>

    @stack('before-scripts')
    <script>

        window.localStorage.setItem('app-language', '<?php echo app()->getLocale() ?? "en"; ?>');

        window.localStorage.setItem('app-languages',
            JSON.stringify(
                <?php echo json_encode(include resource_path() . DIRECTORY_SEPARATOR . 'lang' . DIRECTORY_SEPARATOR . (app()->getLocale() ?? 'en') . DIRECTORY_SEPARATOR . 'default.php')?>
            )
        );

        window.appLanguage = window.localStorage.getItem('app-language');
        window.localStorage.setItem('base_url', '{{request()->root()}}');

        @if(env('APP_INSTALLED') && auth()->user())
        window.localStorage.setItem('permissions', JSON.stringify(
                {!! json_encode(array_merge(
                    resolve(\App\Repositories\Core\Auth\UserRepository::class)->getPermissionsForFrontEnd(),
                    [
                        'is_app_admin' => auth()->user()->isAppAdmin()
                    ])) !!}
        ))

        window.broadcastDriver = "{{config('services.broadcast_custom_driver','pusher')}}";
        window.pusherDriver = <?php echo config('services.broadcast_custom_driver') == 'pusher' ?  json_encode([
            'MIX_PUSHER_APP_KEY'=>config('broadcasting.connections.pusher.key'),
            'MIX_PUSHER_APP_CLUSTER'=>config('broadcasting.connections.pusher.options.cluster')
        ]) : json_encode([
            'MIX_PUSHER_APP_KEY'=>'',
            'MIX_PUSHER_APP_CLUSTER'=>''
        ]) ?>
        @endif

    </script>
    @if(auth()->check())
    <script>
        window.user = <?php echo auth()->user(); ?>;
    </script>
    @endif
    {!! script(mix('js/manifest.js')) !!}
    {!! script(mix('js/vendor.js')) !!}
    {!! script(mix('js/core.js')) !!}
    {!! script('vendor/summernote/summernote-bs4.js') !!}



    @stack('after-scripts')
</footer>
