<!doctype html>
<html dir="{{ config('settings.application.layout') }}" lang="<?php  app()->getLocale(); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">

    <title>@yield('title') - {{ config('app.name') }} </title>
    <link rel="shortcut icon" href="{{ url(config('settings.application.company_icon')) }}" />
    <link rel="apple-touch-icon" href="{{ url(config('settings.application.company_icon')) }}" />
    <link rel="apple-touch-icon-precomposed" href="{{ url(config('settings.application.company_icon')) }}" />

    {{--css assets--}}
    @stack('before-styles')
    {{ style(mix('css/dropzone.css')) }}
    {{ style(mix('css/core.css')) }}
    {{ style(mix('css/fontawesome.css')) }}
    @stack('after-styles')
</head>
<body>
<div id="app">
    {{--page content--}}
    @yield('contents')
</div>
{{--javascript assets--}}
@stack('before-scripts')
<script>
    window.localStorage.setItem('app-language', '<?php echo app()->getLocale() ?? "en"; ?>');

    window.localStorage.setItem('app-languages',
        JSON.stringify(
            <?php echo json_encode(include resource_path() . DIRECTORY_SEPARATOR . 'lang' . DIRECTORY_SEPARATOR . (app()->getLocale() ?? 'en') . DIRECTORY_SEPARATOR . 'default.php') ?>
        )
    );

    window.appLanguage = window.localStorage.getItem('app-language');
    window.localStorage.setItem('base_url', '{{request()->root()}}');
</script>
{!! script(mix('js/manifest.js')) !!}
{!! script(mix('js/vendor.js')) !!}
{!! script(mix('js/core.js')) !!}
@stack('after-scripts')

</body>
</html>