import { axiosGet } from "../../application/helpers/AxiosHelper";
import { TEMPLATE_GENERATOR_DATA } from "../../application/config/ApiUrl";

export default {
  state: () => ({
    templateIndex: 0,
    generator_data: [],
  }),
  mutations: {
    SET_TEMPLATE_GENERATOR_DATA: (state, payloads) =>
      (state.generator_data = payloads),
    INCREASE_TEMPLATE_INDEX: (state) => state.templateIndex++,
  },
  actions: {
    getTemplateGeneratorData(context) {
      axiosGet(TEMPLATE_GENERATOR_DATA).then(({ data }) => {
        context.commit("SET_TEMPLATE_GENERATOR_DATA", data.data);
      });
    },
    increaseTemplateIndex(context) {
      context.commit("INCREASE_TEMPLATE_INDEX");
    },
  },
  getters: {
    ai_models: (state) => {
      if (
        state.generator_data.ai_models &&
        Object.keys(state.generator_data.ai_models).length > 0
      ) {
        return Object.keys(state.generator_data.ai_models).map((key) => {
          return {
            id: key,
            value: state.generator_data.ai_models[key],
          };
        });
      } else {
        return [];
      }
    },
    tones: (state) => {
      if (
        state.generator_data.tones &&
        Object.keys(state.generator_data.tones).length > 0
      ) {
        return Object.keys(state.generator_data.tones).map((key) => {
          return {
            id: key,
            value: state.generator_data.tones[key],
          };
        });
      } else {
        return [];
      }
    },
    creativities: (state) => {
      if (
        state.generator_data.creativities &&
        Object.keys(state.generator_data.creativities).length > 0
      ) {
        return Object.keys(state.generator_data.creativities).map((key) => {
          return {
            id: key,
            value: state.generator_data.creativities[key],
          };
        });
      } else {
        return [];
      }
    },
    languages: (state) => {
      let languges = state.generator_data.languages;
      if (languges) {
        languges.sort(function (a, b) {
          let nameA = a.name.toUpperCase();
          let nameB = b.name.toUpperCase();
          if (nameA > nameB) return 1;
          if (nameA < nameB) return -1;
          return 0;
        });
      } else {
        languges = [];
      }
      return languges;
    },
    templateIndex: (state) => state.templateIndex,
  },
};
