import {axiosGet} from "../../application/helpers/AxiosHelper";
import {GET_STATUSES} from "../../application/config/ApiUrl";

export default {
    state: {
        statuses: [],
    },

    getters: {
        statuses: state => state.statuses,
    },

    mutations: {
        SET_STATUS_LIST(state, data) {
            state.statuses = Vue.prototype.collection(data)
                .shaper();
        }
    },

    actions: {
        getStatuses({commit, rootState}, payload = '') {
            rootState.loading = true;
            axiosGet(`${GET_STATUSES}?type=${payload}`).then((res) => {
                commit('SET_STATUS_LIST', res.data);
                rootState.loading = false;
            })
        }
    },
}
