import {axiosGet} from "../../application/helpers/AxiosHelper";
import {GENERAL_SETTINGS, AI_SETTINGS} from "../../application/config/ApiUrl";

export default {
    state: () => ({
        settings: window.settings,
        aiSettings: {}
    }),
    mutations: {
        SET_SETTINGS: (state, payloads) => state.settings = payloads,
        SET_AI_SETTINGS: (state, payloads) => state.aiSettings = payloads,
    },
    actions: {
        getSettings(context) {
            axiosGet(GENERAL_SETTINGS).then(({data}) => {
                context.commit('SET_SETTINGS', data);
            });
        },
        getAiSettings(context) {
            axiosGet(AI_SETTINGS).then(({data}) => {
                context.commit("SET_AI_SETTINGS", data);
            });
        },
    },
    getters: {
        settings: state => state.settings,
        aiSettings: state => state.aiSettings,
    }
}
