import {axiosGet} from "../../application/helpers/AxiosHelper";
import {LANGUAGE} from "../../application/config/ApiUrl";

export default {
    state: () => ({
        languages: [],
    }),
    mutations: {
        LANGUAGE_LIST(state, data) {
            state.languages = data.map((lang) => {
                return {
                    ...lang,
                    id: lang.key,
                    value: lang.title
                }
            });
        },
    },
    actions: {
        getLanguages({commit, state}) {
            if (!state.languages.length) {
                axiosGet(LANGUAGE).then(({data}) => {
                    commit('LANGUAGE_LIST', data)
                });
            }
        },
    },
    getters: {}
}
