export default {
    namespaced: true,
    state: () => ({
        loading: false,
        list: [],
    }),
    mutations: {
        SET_LOADING: (state, payloads) => state.loading = payloads,
        SET_LIST: (state, payloads) => state.list = payloads,
    },
    actions: {
        getAll(context, payloads) {
            context.commit('SET_LOADING', true)
            return getNotificationData().then(data => {
                context.commit('SET_LIST', data)
                return data
            }).finally(() => {
                context.commit('SET_LOADING', false)
            })
        },
    },
    getters: {
        loading: state => state.loading,
        list: state => state.list,
        get: id => state => state.list.find(item => item.id === id),
    }
}

let getNotificationData = () => {
    return new Promise((resolve, reject) => {
        setTimeout(()=> {
            return resolve(data)
        }, 1000)
    })
}

const data = [
    {read: true, string: 'notification 1'},
    {read: false, string: 'notification 2'},
    {read: true, string: 'notification 3'},
    {read: false, string: 'notification 4'},
    {read: true, string: 'notification 5'},
    {read: false, string: 'notification 6'},
    {read: true, string: 'notification 7'},
    {read: true, string: 'notification 8'},
    {read: false, string: 'notification 9'},
    {read: true, string: 'notification 10'},
    {read: true, string: 'notification 11'},
    {read: false, string: 'notification 12'},
    {read: true, string: 'notification 13'},
    {read: false, string: 'notification 14'},
    {read: true, string: 'notification 15'},
    {read: true, string: 'notification 16'},
    {read: true, string: 'notification 17'},
    {read: true, string: 'notification 18'},
    {read: true, string: 'notification 19'},
    {read: true, string: 'notification 20'},
]