import { axiosGet } from "../../application/helpers/AxiosHelper";
import { GET_CATEGORIES } from "../../application/config/ApiUrl";

export default {
  state: () => ({
    categories: [],
  }),
  mutations: {
    SET_CATEGORIES: (state, payloads) => (state.categories = payloads),
  },
  actions: {
    getTypeWiseCategory(context, payload) {
      axiosGet(GET_CATEGORIES, { params: payload }).then(({ data }) => {
        context.commit("SET_CATEGORIES", data.data);
      });
    },
  },
  getters: {
    categories: (state) => state.categories,
  },
};
