import Vue from 'vue'
import Vuex from 'vuex';

import notifications from './modules/Notifications';
import notificationSettings from './modules/NotificationSettings';
import ClientNotifications from './modules/ClientNotifications'
import settings from './modules/Settings';
import language from './modules/Language';
import status from './modules/Statuses';
import user from './modules/user/User';
import userAndRoles from './modules/user/UserRoles';
import template from './modules/Template';
import category from './modules/Category';

Vue.use(Vuex)

const store = new Vuex.Store(
    {
        state: () => ({
            loading: false,
            theme: {
                darkMode: false,
            }
        }),
        mutations: {
            SET_LOADER: (state, payloads) => state.loading = payloads,
            SET_DARK_MODE: (state, payloads) => state.darkMode = payloads
        },
        actions: {
            init({ dispatch, commit }) {
                dispatch('getUser')
                dispatch('getLanguages')
                dispatch('getNotifications')
                commit('SET_DARK_MODE', localStorage.theme === 'dark')
            }
        },
        getters: {
            loading: state => state.loading,
            darkMode: state => state.theme.darkMode
        },
        modules: {
            notifications,
            notificationSettings,
            ClientNotifications,
            settings,
            language,
            status,
            user,
            userAndRoles,
            template,
            category
        }
    }
);

export default store
