import './bootstrap';
import './plugins';
import Vue from 'vue';
import vuexI18n from 'vuex-i18n';
import './application/helpers/global/Translator'
import './application/helpers/global/helpers'
import './core/coreApp';
import './application/appComponents';
window.Vue = Vue;

import store from "./store/Index";

/**
 * localization
 * $t('key') or this.$('key')
 * link: https://github.com/dkfbasel/vuex-i18n
 * */
Vue.use(vuexI18n.plugin, store);

const translationsEn = localStorage.getItem("app-languages");

const translationsDe = {
    "My nice title": "Ein schöner Titel",
    "content": "Dies ist ein toller Inhalt"
};

// add translations directly to the application
Vue.i18n.add('en', JSON.parse(translationsEn));
Vue.i18n.add('de', translationsDe);
// set the start locale to use
Vue.i18n.set('en');

/*------ localization end ------*/


const app = new Vue({
    store,
    strict: true,
    el: '#app',
});

let user = document.querySelector('meta[name~="user"]')

if(user){
    app.$store.dispatch('init');
}

