import coreLibrary from "../../../core/helpers/CoreLibrary";
import { COMPLETION_DAILY_LIMIT } from "../../config/ApiUrl";

export default {
  extends: coreLibrary,
  data() {
    return {
      limit: true,
    };
  },
  created() {
    this.checkDailyLimit();
  },
  methods: {
    checkDailyLimit() {
      this.axiosGet(COMPLETION_DAILY_LIMIT).then(({ data }) => {
        this.limit = data.data.limit;
      });
    },
  },
  computed: {
    dailyLimit() {
      return this.limit;
    },
  },
};
