import coreLibrary from "../../../core/helpers/CoreLibrary";
import {
  GET_FAVORITE_TEMPLATE,
  ADD_FAVORITE_TEMPLATE,
} from "../../config/ApiUrl";

export default {
  extends: coreLibrary,
  data() {
    return {
      favoriteTemplateChange: 0,
      favoriteTemplates: [],
    };
  },
  created() {
    this.getFavoriteTemplate();
  },
  methods: {
    favorite(value) {
      this.axiosPost({
        url: ADD_FAVORITE_TEMPLATE,
        data: { template_id: value },
      }).then((response) => {
        this.setFavoriteTemplate(response.data.data);
        this.$toastr.s("", response.data.message);
      });
    },
    getFavoriteTemplate() {
      this.axiosGet(GET_FAVORITE_TEMPLATE).then((response) => {
        this.setFavoriteTemplate(response.data.data);
      });
    },
    setFavoriteTemplate(favoriteTemplate) {
      this.favoriteTemplates = favoriteTemplate.map((item) => {
        return item.template_id;
      });
      this.favoriteTemplateChange++;
      this.$store.dispatch("increaseTemplateIndex");
    },
  },
  computed: {
    favoriteTemplateList() {
      return this.favoriteTemplates;
    },
  },
};
