import {mapState} from "vuex";

export default {
    computed: {
        ...mapState({
            categories: state => state.category.categories
        }),
        categoriesObjectWatcher() {
            return this.categories.length
        }
    },
    watch: {
        categoriesObjectWatcher: {
            handler: function (length) {
                if (length) {
                    this.options.filters.find(({key, option}) => {
                        if (key === 'category') option.push(...this.categories)
                    })
                }
            },
            immediate: true
        }
    }
}
