import { DOCUMENT_LIST, DOCUMENT_DELETE } from "../../config/ApiUrl";
import moment from "moment";

export default {
  data() {
    return {
      options: {
        name: this.$t("document"),
        url: DOCUMENT_LIST,
        showHeader: true,
        showCount: true,
        columns: [
          {
            title: this.$t("name"),
            type: "text",
            key: "name",
            isVisible: true,
          },
          {
            title: this.$t("category"),
            type: "custom-html",
            key: "category",
            isVisible: true,
            modifier: (category) => category.name,
          },
          {
            title: this.$t('content'),
            type: 'component',
            key: 'content',
            componentName: 'app-ai-document-content',
          },
          {
            title: this.$t("created_at"),
            type: "custom-html",
            key: "created_at",
            isVisible: true,
            modifier: (value) => {
              return moment(value).format("DD MMM YYYY, hh:mm a");
            },
          },
          {
            title: this.$t("actions"),
            type: "action",
            key: "actions",
            isVisible: true,
          },
        ],
        filters: [
          {
            title: this.$t("created"),
            type: "range-picker",
            key: "date",
            option: ["today", "thisMonth", "last7Days", "thisYear"],
          },
          {
            title: this.$t('category'),
            type: "checkbox",
            key: "category",
            option: [],
            listValueField: 'name'
          },
        ],
        paginationType: "pagination",
        responsive: true,
        rowLimit: 10,
        showAction: true,
        orderBy: "desc",
        actionType: "default",
        actions: [
          {
            title: this.$t("edit"),
            icon: "edit",
            type: "modal",
            modalId: "app-modal",
            url: "",
            name: "edit",
          },
          {
            title: this.$t("delete"),
            icon: "trash-2",
            type: "modal",
            component: "app-confirmation-modal",
            modalId: "app-confirmation-modal",
            url: DOCUMENT_DELETE,
            name: "delete",
          },
        ],
      },
    };
  },
};
