import coreLibrary from "../../../core/helpers/CoreLibrary";
import { DOCUMENT_UPDATE } from "../../config/ApiUrl";
import HelperMixin from "../global/HelperMixin";
export default {
  extends: coreLibrary,
  mixins: [HelperMixin],
  data() {
    return {
      documentId: 0,
      categoryId: 0,
      documentName: "",
      documentContent: "",
      updateUrl: DOCUMENT_UPDATE,
      submitForm: false,
    };
  },
  created() {
    this.getDocumentData();
  },
  methods: {
    submit() {
      this.submitForm = true;
    },
    documentUpdated(message) {
      $("#document-edit-modal").modal("hide");
      this.toastAndReload(message, "document-table");
      this.submitForm = false;
    },
    getDocumentData() {
      this.axiosGet(this.selectedUrl).then((response) => {
        this.setDocumentData(response.data.data);
      });
    },
    setDocumentData(document) {
      this.documentId = document.id;
      this.categoryId = document.category_id;
      this.documentName = document.name;
      this.documentContent = document.content;
    },
  },
};
