export const ModalMixin = {
    props: {
        value: {
            required: true,
        }
    },
    data() {
        return {
            showModal: false,
            preloader: false
        }
    },
    created() {
        this.showModal = this.value;
    },
    watch: {
        showModal: function (value) {
            if (!value) {
                this.$emit('input', value)
            }
        }
    },
    methods: {
        closeModal() {
            this.showModal = false
            this.$emit('close-modal');
        },
    }
};