import Vue from 'vue'

Vue.prototype.$placeholder = (subject, key = null) => {
    return Vue.prototype.$t('place_holder', {
        subject: Vue.prototype.$t(subject).toLowerCase(),
        type: key ? Vue.prototype.$t(key).toLowerCase() : ''
    });
};

Vue.prototype.$fieldTitle = (subject, title = null, titleCapitalize = false, infix = null) => {
    if (title) {
        let firstWord = Vue.prototype.$t(subject);
        let firstLetter = firstWord.slice(0,1);
        firstWord = firstLetter.toUpperCase() + firstWord.substring(1);
        let translation = Vue.prototype.$t('field_title', {
            subject: firstWord,
            infix: infix ? Vue.prototype.$t(infix).toLowerCase() : '',
            title: titleCapitalize ? Vue.prototype.$t(title) : Vue.prototype.$t(title).toLowerCase()
        })
        return translation.split(' ').filter(a => a).join(' ');
    }
    return Vue.prototype.$t(subject);
};