import sanitizeHtml from 'sanitize-html';
const sanitize = (dirty = '') => {
    let options = {
        allowedTags: [ 'b', 'i', 'em', 'strong', 'a', 'img', 'iframe'],
        allowedAttributes: {
            'a': [ 'href' ],
            'img': ['src', 'style', 'class'],
            'iframe': ['width', 'height', 'src', 'frameborder', 'allowfullscreen']
        },
        allowedSchemes: [ 'data', 'http', 'https', 'blob'],
        allowedIframeHostnames: ['www.youtube.com', 'player.vimeo.com'],
    };
    return sanitizeHtml(dirty, options);
}

export default sanitize;
