import Vue from 'vue';

// helper components
import '../application/components/Helpers/HelperComponent';

// components
Vue.component('app-login', require('./components/views/Auth/Login').default);
Vue.component('app-password-reset', require('./components/views/Auth/PasswordReset').default);
Vue.component('app-reset-password', require('./components/views/Auth/ResetPassword').default);
Vue.component('app-confirm-invitation', require('./components/views/Auth/ConfirmInvitation').default);
Vue.component('app-registration', require('./components/views/Auth/Registration').default);
Vue.component('app-email-verification', require('./components/views/Auth/ResentEmailVerification').default);
Vue.component('app-navbar-view', require('./components/Layouts/Navbar').default);
Vue.component('app-sidebar-view', require('./components/Layouts/Sidebar').default);


Vue.component('general-setting', require('./components/views/Settings/GeneralSetting').default);
Vue.component('email-setting', require('./components/views/Settings/EmailSetting').default);
Vue.component('notification-settings', require('./components/views/Settings/Notification/Settings/Index').default);
Vue.component('personal-information', require('./components/views/Auth/PersonalInformation').default);
Vue.component('password-change', require('./components/views/Auth/PasswordChange').default);
Vue.component('social-links', require('./components/views/Auth/SocialLinks').default);
Vue.component('broadcast-setup', require('./components/views/Settings/BroadcastSetup').default);

// users and roles
Vue.component('group-of-users', require('./components/views/UserRoles/Roles/GroupOfUsers').default);

// notification
Vue.component('database-template', require('./components/views/Settings/Notification/Template/DatabaseTemplate').default);
Vue.component('mail-template', require('./components/views/Settings/Notification/Template/MailTemplate').default);

//Pages
Vue.component('page-dashboard', require('./components/views/Dashboard').default);
Vue.component('page-profile', require('./components/views/Auth/Profile').default);
Vue.component('page-users-roles', require('./components/views/UserRoles/Index').default);
Vue.component('page-settings', require('./components/views/Settings/Index').default);
Vue.component('page-notification', require('./components/views/Auth/Notification').default);

// Update
Vue.component('app-update', require('./components/views/Update/template/Update').default);
Vue.component('app-manual-updater', require('./components/views/Update/template/ManualUpdater').default);
Vue.component('app-update-confirmation-modal', require('./components/views/Update/template/UpdateConfirmationModal').default);

//report
Vue.component('app-user-media-object', require('./components/views/UserRoles/Users/MediaObject').default);

Vue.component('test-page', require('./components/views/Test').default);

// Template 
Vue.component('app-ai-template-list', require('./components/views/Template/Index').default);
Vue.component('app-ai-generator-form', require('./components/views/Template/GeneratorForm').default);

// Document
Vue.component('app-ai-document-list', require('./components/views/Document/Index').default);
Vue.component('app-ai-document-content', require('./components/views/Document/DocumentContent').default);

//ai
Vue.component('ai-setup', require('./components/views/Settings/AiSetup').default);
