<?php
namespace Database\Seeders\UpdateSeeder;

use App\Models\Core\Auth\Permission;
use App\Models\Core\Auth\Type;
use Database\Seeders\Traits\DisableForeignKeys;
use Illuminate\Database\Seeder;
class RolePermissionUpdateSeeder extends Seeder
{
    use DisableForeignKeys;
    /**
     * Run the database seeders.
     *
     * @return void
     */
    public function run()
    {
        $this->disableForeignKeys();

        $this->seedNewPermissions();

        $this->enableForeignKeys();
    }

    public function seedNewPermissions() {
        $this->disableForeignKeys();
        $appId = Type::findByAlias('app')->id;

        $new_permissions = [
            //reports
            [
                'name' => 'view_reports',
                'type_id' => $appId,
                'group_name' => 'report'
            ],
            [
                'name' => 'view_report_types',
                'type_id' => $appId,
                'group_name' => 'report'
            ],

        ];

        $this->enableForeignKeys();
        Permission::query()->insert($new_permissions);
    }
}
