<?php
namespace Database\Seeders\Status;

use App\Models\Core\Status;
use Database\Seeders\Traits\DisableForeignKeys;
use Illuminate\Database\Seeder;

class StatusSeeder extends Seeder
{
    use DisableForeignKeys;
    /**
     * Run the database seeders.
     *
     * @return void
     */
    public function run()
    {
        $this->disableForeignKeys();
        Status::query()->truncate();
        $statuses = [
            [
                'name' => 'status_active',
                'type' => 'user',
                'class' => 'success'
            ],
            [
                'name' => 'status_inactive',
                'type' => 'user',
                'class' => 'danger'
            ],
            [
                'name' => 'status_invited',
                'type' => 'user',
                'class' => 'purple'
            ],
            [
                'name' => 'status_unverified',
                'type' => 'user',
                'class' => 'warning'
            ],
            [
                'name' => 'status_active',
                'type' => 'category',
                'class' => 'success'
            ],
            [
                'name' => 'status_inactive',
                'type' => 'category',
                'class' => 'danger'
            ],
            [
                'name' => 'status_active',
                'type' => 'template',
                'class' => 'success'
            ],
            [
                'name' => 'status_inactive',
                'type' => 'template',
                'class' => 'danger'
            ],
            //Example table status
            [
                'name' => 'status_active',
                'type' => 'example',
                'class' => 'success'
            ],
            [
                'name' => 'status_inactive',
                'type' => 'example',
                'class' => 'danger'
            ],
        ];

        Status::query()->insert($statuses);

        $this->enableForeignKeys();
    }
}
