<?php
namespace Database\Seeders;

use Database\Seeders\Application\ApplicationPermissionRoleSeeder;
use Database\Seeders\Application\CategorySeeder;
use Database\Seeders\Application\NotificationChannelTableSeeder;
use Database\Seeders\Application\NotificationEventTableSeeder;
use Database\Seeders\Application\NotificationSettingsSeeder;
use Database\Seeders\Application\NotificationTemplateSeeder;
use Database\Seeders\Application\SettingTableSeeder;
use Database\Seeders\Application\AiSettingTableSeeder;
use Database\Seeders\Application\SocialLinkSeeder;
use Database\Seeders\Application\TemplateSeeder;
use Database\Seeders\Application\UserSocialLinkSeeder;
use Database\Seeders\Auth\PermissionRoleTableSeeder;
use Database\Seeders\Auth\PermissionTableSeeder;
use Database\Seeders\Builder\CustomFieldTypeSeeder;
use Database\Seeders\Traits\DisableForeignKeys;
use Database\Seeders\Traits\TruncateTable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Seeder;

class SetupSeeder extends Seeder
{
    use TruncateTable, DisableForeignKeys;

    /**
     * Seed the application's database.
     */
    public function run()
    {
        Model::unguard();
        $this->disableForeignKeys();
        /*For Basic Application*/
        $this->call(PermissionTableSeeder::class);
        $this->call(PermissionRoleTableSeeder::class);
        $this->call(SettingTableSeeder::class);
        $this->call(AiSettingTableSeeder::class);
        $this->call(CustomFieldTypeSeeder::class);
        $this->call(NotificationChannelTableSeeder::class);
        $this->call(NotificationEventTableSeeder::class);
        $this->call(NotificationSettingsSeeder::class);
        $this->call(NotificationTemplateSeeder::class);
        $this->call(SocialLinkSeeder::class);
        $this->call(UserSocialLinkSeeder::class);

        /*For BrainBox*/
        $this->call(ApplicationPermissionRoleSeeder::class);
        $this->call(CategorySeeder::class);
        $this->call(TemplateSeeder::class);

        $this->enableForeignKeys();
        Model::reguard();
    }
}
