<?php

namespace Database\Seeders\Auth;

use App\Models\Core\Auth\Permission;
use App\Models\Core\Auth\Type;
use Database\Seeders\Traits\DisableForeignKeys;
use Illuminate\Database\Seeder;

class PermissionTableSeeder extends Seeder
{
    use DisableForeignKeys;
    /**
     * Run the database seeders.
     *
     * @return void
     */
    public function run()
    {
        $this->disableForeignKeys();
        Permission::query()->truncate();
        $appId = Type::findByAlias('app')->id;

        $permissions = [
            //users
            [
                'name' => 'view_users',
                'type_id' => $appId,
                'group_name' => 'users'
            ],
            [
                'name' => 'manage_dashboard',
                'type_id' => $appId,
                'group_name' => 'dashboard'
            ],
            [
                'name' => 'create_users',
                'type_id' => $appId,
                'group_name' => 'users'
            ],
            [
                'name' => 'update_users',
                'type_id' => $appId,
                'group_name' => 'users'
            ],
            [
                'name' => 'delete_users',
                'type_id' => $appId,
                'group_name' => 'users'
            ],
            [
                'name' => 'cancel_user_invitation',
                'type_id' => $appId,
                'group_name' => 'users'
            ],
            [
                'name' => 'attach_roles_users',
                'type_id' => $appId,
                'group_name' => 'users'
            ],
            [
                'name' => 'detach_roles_users',
                'type_id' => $appId,
                'group_name' => 'users'
            ],
            [
                'name' => 'invite_user',
                'type_id' => $appId,
                'group_name' => 'users'
            ],
            //end users
            //roles
            [
                'name' => 'view_roles',
                'type_id' => $appId,
                'group_name' => 'roles'
            ],
            [
                'name' => 'create_roles',
                'type_id' => $appId,
                'group_name' => 'roles'
            ],
            [
                'name' => 'update_roles',
                'type_id' => $appId,
                'group_name' => 'roles'
            ],
            [
                'name' => 'delete_roles',
                'type_id' => $appId,
                'group_name' => 'roles'
            ],
            [
                'name' => 'attach_users_to_roles',
                'type_id' => $appId,
                'group_name' => 'roles'
            ],
            //permission
            [
                'name' => 'attach_permissions_roles',
                'type_id' => $appId,
                'group_name' => 'permissions'
            ],
            [
                'name' => 'detach_permissions_roles',
                'type_id' => $appId,
                'group_name' => 'permissions'
            ],

            //settings
            [
                'name' => 'view_settings',
                'type_id' => $appId,
                'group_name' => 'settings'
            ],
            [
                'name' => 'update_settings',
                'type_id' => $appId,
                'group_name' => 'settings'
            ],
            [
                'name' => 'update_delivery_settings',
                'type_id' => $appId,
                'group_name' => 'settings'
            ],
            [
                'name' => 'view_delivery_settings',
                'type_id' => $appId,
                'group_name' => 'settings'
            ],
            [
                'name' => 'view_notification_settings',
                'type_id' => $appId,
                'group_name' => 'settings'
            ],
            [
                'name' => 'update_notification_settings',
                'type_id' => $appId,
                'group_name' => 'settings'
            ],
            [
                'name' => 'view_ai_settings',
                'type_id' => $appId,
                'group_name' => 'settings'
            ],
            [
                'name' => 'update_ai_settings',
                'type_id' => $appId,
                'group_name' => 'settings'
            ],
            //end of settings
            // dashboard permissions
            [
                'name' => 'view_user_summary',
                'type_id' => $appId,
                'group_name' => 'dashboard'
            ],
            // end of dashboard permissions

            //Notification Templates
            [
                'name' => 'view_notification_templates',
                'type_id' => $appId,
                'group_name' => 'templates'
            ],
            [
                'name' => 'create_notification_templates',
                'type_id' => $appId,
                'group_name' => 'templates'
            ],
            [
                'name' => 'update_notification_templates',
                'type_id' => $appId,
                'group_name' => 'templates'
            ],
            [
                'name' => 'delete_notification_templates',
                'type_id' => $appId,
                'group_name' => 'templates'
            ],
            [
                'name' => 'view_activity_logs',
                'type_id' => $appId,
                'group_name' => 'log'
            ],

            //  templates table permission
            [
                'name' => 'view_ai_template',
                'type_id' => $appId,
                'group_name' => 'ai_template'
            ],
            [
                'name' => 'view_ai_template_summary',
                'type_id' => $appId,
                'group_name' => 'ai_template'
            ],
            [
                'name' => 'create_ai_template',
                'type_id' => $appId,
                'group_name' => 'ai_template'
            ],
            [
                'name' => 'update_ai_template',
                'type_id' => $appId,
                'group_name' => 'ai_template'
            ],
            [
                'name' => 'delete_ai_template',
                'type_id' => $appId,
                'group_name' => 'ai_template'
            ],
            // Completion table permission
            [
                'name' => 'view_completion',
                'type_id' => $appId,
                'group_name' => 'completion'
            ],
            [
                'name' => 'view_completion_summary',
                'type_id' => $appId,
                'group_name' => 'completion'
            ],
            [
                'name' => 'view_completion_overview',
                'type_id' => $appId,
                'group_name' => 'completion'
            ],
            [
                'name' => 'create_completion',
                'type_id' => $appId,
                'group_name' => 'completion'
            ],
            [
                'name' => 'update_completion',
                'type_id' => $appId,
                'group_name' => 'completion'
            ],
            [
                'name' => 'delete_completion',
                'type_id' => $appId,
                'group_name' => 'completion'
            ],

            // Document table permission
            [
                'name' => 'view_document',
                'type_id' => $appId,
                'group_name' => 'document'
            ],
            [
                'name' => 'view_document_summary',
                'type_id' => $appId,
                'group_name' => 'document'
            ],
            [
                'name' => 'view_document_overview',
                'type_id' => $appId,
                'group_name' => 'document'
            ],
            [
                'name' => 'create_document',
                'type_id' => $appId,
                'group_name' => 'document'
            ],
            [
                'name' => 'update_document',
                'type_id' => $appId,
                'group_name' => 'document'
            ],
            [
                'name' => 'delete_document',
                'type_id' => $appId,
                'group_name' => 'document'
            ],
        ];

        $this->enableForeignKeys();
        Permission::query()->insert($permissions);
    }
}
