<?php

namespace Database\Seeders\Application;

use App\Models\Application\User\SocialLink;
use App\Models\Core\Auth\User;
use Illuminate\Database\Seeder;

class UserSocialLinkSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $users = User::get();
        $socialLinks = SocialLink::pluck('id')->toArray();
        foreach ($users as $user) {
            $user->assignSocialLinks($socialLinks);
        }
    }
}
