<?php
namespace Database\Seeders\Application;

use App\Models\Core\Auth\Profile;
use App\Models\Core\Auth\Role;
use App\Models\Core\Auth\Type;
use App\Models\Core\Auth\User;
use App\Models\Core\Status;
use Faker\Factory as Faker;
use Illuminate\Database\Seeder;
use App\Models\Application\User\SocialLink;
use Illuminate\Support\Facades\Hash;

class UserDemoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $faker = Faker::create();
        $socialLinks = SocialLink::get();

        $socialLinksWithPivot = [];
        foreach ($socialLinks as $socialLink) {
            $socialLinksWithPivot[$socialLink->id] = ['link' => "http://".$socialLink->name.".com"];
        }
        $socialLinks = $socialLinks->pluck('id')->toArray();

        $superAdmin = User::first();
        $superAdmin->assignSocialLinks($socialLinksWithPivot);

        Profile::query()->create([
            'user_id' => $superAdmin->id,
            'gender' => 'male',
            'date_of_birth' => now()->subYear(25),
            'address' => $faker->address,
            'about' => $faker->paragraph,
            'contact' => $faker->phoneNumber
        ]);
        // seed profile

        $role = Role::firstOrCreate(
            [
                'name' => 'User',
            ],
            [
                'is_admin' => 0,
                'type_id' => Type::findByAlias('app')->id,
                'created_by' => $superAdmin->id,
                'is_default' => 0
            ]);

        $user = User::query()->create([
            'first_name' => 'Mark',
            'last_name' => 'Nam',
            'email' => 'user@demo.com',
            'password' => Hash::make('123456'),
            'status_id' => Status::findByNameAndType('status_active', 'user')->id
        ]);
        $user->assignSocialLinks($socialLinksWithPivot);
        $user->assignRole($role);
        // seed profile
        Profile::query()->create([
            'user_id' => $user->id,
            'gender' => 'male',
            'date_of_birth' => now()->subYear(25),
            'address' => $faker->address,
            'about' => $faker->paragraph,
            'contact' => $faker->phoneNumber
        ]);

        User::factory(30)->create()->each(function (User $user) use ($socialLinks, $role){
            $user->assignSocialLinks($socialLinks);
            $user->assignRole($role);
            echo " .";
        });
        echo "\n";
    }
}
