<?php

namespace Database\Seeders\Application;

use App\Models\Core\Status;
use App\Models\Application\AI\Template;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class TemplateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Template::query()->truncate();

        Template::insert(
            [
                [
                    'category_id' => 1,
                    'name' => 'Blog Title',
                    'slug' => Str::slug('Blog Title', '-'),
                    'description' => 'Nobody wants to read boring blog titles, generate catchy blog titles with this tool',
                    'toneable' => 0,
                    'status_id' => Status::findByNameAndType('status_active', 'template')->id,
                    'icon' => '',
                    'fields' => json_encode([
                        [
                            'level' => 'What is your blog post is about?',
                            'key' => 'description',
                            'type' => 'textarea',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ]
                    ]),
                    'postfix' => 'Please make blog title list about this.'
                ],
                [
                    'category_id' => 1,
                    'name' => 'Blog Intros',
                    'slug' => Str::slug('Blog Intros', '-'),
                    'description' => 'Write an intro that will entice your visitors to read more about your article',
                    'toneable' => 1,
                    'status_id' => Status::findByNameAndType('status_active', 'template')->id,
                    'icon' => '',
                    'fields' => json_encode([
                        [
                            'level' => 'What is your blog post is about?',
                            'key' => 'description',
                            'type' => 'textarea',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ]
                    ]),
                    'postfix' => 'Please write a blog intro that will entice visitors to read more about this article.'
                ],
                [
                    'category_id' => 1,
                    'name' => 'Blog Section',
                    'slug' => Str::slug('Blog Section', '-'),
                    'description' => 'Write a full blog section (few paragraphs) about a subheading of your article',
                    'toneable' => 1,
                    'status_id' => Status::findByNameAndType('status_active', 'template')->id,
                    'icon' => '',
                    'fields' => json_encode([
                        [
                            'level' => 'What is your blog post is about?',
                            'key' => 'description',
                            'type' => 'textarea',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ]
                    ]),
                    'postfix' => 'Please write a full blog section (few paragraphs) about a subheading of this article'
                ],
                [
                    'category_id' => 1,
                    'name' => 'Blog Conclusion',
                    'slug' => Str::slug('Blog Conclusion', '-'),
                    'description' => 'End your blog articles with an engaging conclusion paragraph',
                    'toneable' => 1,
                    'status_id' => Status::findByNameAndType('status_active', 'template')->id,
                    'icon' => '',
                    'fields' => json_encode([
                        [
                            'level' => 'Blog Post Title',
                            'key' => 'title',
                            'type' => 'text',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ],
                        [
                            'level' => 'What is your blog post is about?',
                            'key' => 'description',
                            'type' => 'textarea',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ]
                    ]),
                    'postfix' => 'Please write a blog conclusion about this.'
                ],
                [
                    'category_id' => 2,
                    'name' => 'Article Generator',
                    'slug' => Str::slug('Article Generator', '-'),
                    'description' => 'Turn a title and outline text into a fully complete high quality article within seconds',
                    'toneable' => 1,
                    'status_id' => Status::findByNameAndType('status_active', 'template')->id,
                    'icon' => '',
                    'fields' => json_encode([
                        [
                            'level' => 'Article Title',
                            'key' => 'title',
                            'type' => 'text',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ],
                        [
                            'level' => 'Focus Keywords',
                            'key' => 'keywords',
                            'type' => 'text',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ]
                    ]),
                    'postfix' => 'Please write a article about this.'
                ],
                [
                    'category_id' => 2,
                    'name' => 'Content Rewriter',
                    'slug' => Str::slug('Content Rewriter', '-'),
                    'description' => 'Take a piece of content and rewrite it to make it more interesting, creative, and engaging',
                    'toneable' => 1,
                    'status_id' => Status::findByNameAndType('status_active', 'template')->id,
                    'icon' => '',
                    'fields' => json_encode([
                        [
                            'level' => 'What would you like to rewrite?',
                            'key' => 'content',
                            'type' => 'textarea',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ]
                    ]),
                    'postfix' => 'Please rewrite the content to make it more interesting, creative, and engaging.'
                ],
                [
                    'category_id' => 2,
                    'name' => 'Paragraph Generator',
                    'slug' => Str::slug('Paragraph Generator', '-'),
                    'description' => 'Generate paragraphs about any topic including a keyword and in a specific tone of voice',
                    'toneable' => 1,
                    'status_id' => Status::findByNameAndType('status_active', 'template')->id,
                    'icon' => '',
                    'fields' => json_encode([
                        [
                            'level' => 'Paragraph Title',
                            'key' => 'description',
                            'type' => 'textarea',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ],
                        [
                            'level' => 'Focus Keywords',
                            'key' => 'keywords',
                            'type' => 'text',
                            'required' => false,
                            'placeholder' => 'Enter here'
                        ]
                    ]),
                    'postfix' => 'Please write a paragraph about mentioned topic including keyword and specified tone of voice'
                ],
                [
                    'category_id' => 2,
                    'name' => 'Product Description',
                    'slug' => Str::slug('Product Description', '-'),
                    'description' => 'Write the description about your product and why it worth it.',
                    'toneable' => 1,
                    'status_id' => Status::findByNameAndType('status_active', 'template')->id,
                    'icon' => '',
                    'fields' => json_encode([
                        [
                            'level' => 'Product Name',
                            'key' => 'product_name',
                            'type' => 'text',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ],
                        [
                            'level' => 'Audience',
                            'key' => 'audience',
                            'type' => 'text',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ],
                        [
                            'level' => 'Product Description',
                            'key' => 'description',
                            'type' => 'textarea',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ]
                    ]),
                    'postfix' => 'Please write product description about this product and why it worth it.'
                ],
                [
                    'category_id' => 2,
                    'name' => 'Summarize Text',
                    'slug' => Str::slug('Summarize Text', '-'),
                    'description' => 'Summmarize any text in a short and easy to understand concise way.',
                    'toneable' => 0,
                    'status_id' => Status::findByNameAndType('status_active', 'template')->id,
                    'icon' => '',
                    'fields' => json_encode([
                        [
                            'level' => 'What would you like to summarize?',
                            'key' => 'content',
                            'type' => 'textarea',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ]
                    ]),
                    'postfix' => 'Please summmarize this content in a short and easy to understand concise way.'
                ],
                [
                    'category_id' => 3,
                    'name' => 'Welcome Email',
                    'slug' => Str::slug('Welcome Email', '-'),
                    'description' => 'Create welcome emails for your customers.',
                    'toneable' => 1,
                    'status_id' => Status::findByNameAndType('status_active', 'template')->id,
                    'icon' => '',
                    'fields' => json_encode([
                        [
                            'level' => 'Your Company/Product Name',
                            'key' => 'name',
                            'type' => 'text',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ],
                        [
                            'level' => 'Describe your product or company',
                            'key' => 'description',
                            'type' => 'textarea',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ],
                        [
                            'level' => 'Audience',
                            'key' => 'audience',
                            'type' => 'text',
                            'required' => false,
                            'placeholder' => 'Enter here'
                        ]
                    ]),
                    'postfix' => 'Please write a welcome email about mentioned details.'
                ],
                [
                    'category_id' => 3,
                    'name' => 'Cold Email',
                    'slug' => Str::slug('Cold Email', '-'),
                    'description' => 'Create professional cold emails with the help of AI.',
                    'toneable' => 1,
                    'status_id' => Status::findByNameAndType('status_active', 'template')->id,
                    'icon' => '',
                    'fields' => json_encode([
                        [
                            'level' => 'Your Company/Product Name',
                            'key' => 'name',
                            'type' => 'text',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ],
                        [
                            'level' => 'Describe your product or company',
                            'key' => 'description',
                            'type' => 'textarea',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ],
                        [
                            'level' => 'Email Context',
                            'key' => 'email_context',
                            'type' => 'textarea',
                            'required' => false,
                            'placeholder' => 'Enter here'
                        ]
                    ]),
                    'postfix' => 'Please write a professional cold email about mentioned details.',
                ],
                [
                    'category_id' => 3,
                    'name' => 'Follow-Up Email',
                    'slug' => Str::slug('Follow-Up Email', '-'),
                    'description' => 'Create professional email follow up with just few clicks.',
                    'toneable' => 1,
                    'status_id' => Status::findByNameAndType('status_active', 'template')->id,
                    'icon' => '',
                    'fields' => json_encode([
                        [
                            'level' => 'Your Company/Product Name',
                            'key' => 'name',
                            'type' => 'text',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ],
                        [
                            'level' => 'Describe your product or company',
                            'key' => 'description',
                            'type' => 'textarea',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ],
                        [
                            'level' => 'Following up about',
                            'key' => 'previous_email',
                            'type' => 'textarea',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ]
                    ]),
                    'postfix' => 'Please write a follow-up email about mentioned details.'
                ],
                [
                    'category_id' => 5,
                    'name' => 'Instagram Captions',
                    'slug' => Str::slug('Instagram Captions', '-'),
                    'description' => 'Grab attention with catchy captions for your Instagram posts.',
                    'toneable' => 1,
                    'status_id' => Status::findByNameAndType('status_active', 'template')->id,
                    'icon' => '',
                    'fields' => json_encode([
                        [
                            'level' => 'What is your instragram post about?',
                            'key' => 'context',
                            'type' => 'textarea',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ],
                        [
                            'level' => 'Audience',
                            'key' => 'audience',
                            'type' => 'text',
                            'required' => false,
                            'placeholder' => 'Enter here'
                        ]
                    ]),
                    'postfix' => 'Please write a attractive and catchy captions for instagram post.'
                ],
                [
                    'category_id' => 5,
                    'name' => 'Facebook Ads',
                    'slug' => Str::slug('Facebook Ads', '-'),
                    'description' => 'Write Facebook ads that engage your audience and deliver a high conversion rate.',
                    'toneable' => 1,
                    'status_id' => Status::findByNameAndType('status_active', 'template')->id,
                    'icon' => '',
                    'fields' => json_encode([
                        [
                            'level' => 'Product Name',
                            'key' => 'product_name',
                            'type' => 'text',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ],
                        [
                            'level' => 'Describe your product',
                            'key' => 'description',
                            'type' => 'textarea',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ],
                        [
                            'level' => 'Audience',
                            'key' => 'audience',
                            'type' => 'text',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ]
                    ]),
                    'postfix' => 'Please write a facebook ads that engage my audience and deliver a high conversion rate.'
                ],
                [
                    'category_id' => 5,
                    'name' => 'Google Ads Description',
                    'slug' => Str::slug('Google Ads Description', '-'),
                    'description' => 'Write a Google Ads description that makes your ad stand out and generates leads.',
                    'toneable' => 1,
                    'status_id' => Status::findByNameAndType('status_active', 'template')->id,
                    'icon' => '',
                    'fields' => json_encode([
                        [
                            'level' => 'Product Name',
                            'key' => 'product_name',
                            'type' => 'text',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ],
                        [
                            'level' => 'Describe your product',
                            'key' => 'description',
                            'type' => 'textarea',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ],
                        [
                            'level' => 'Audience',
                            'key' => 'audience',
                            'type' => 'text',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ]
                    ]),
                    'postfix' => 'Please write a Google Ads description that makes my ad stand out and generates leads.'
                ],
                [
                    'category_id' => 5,
                    'name' => 'Social Media Post (Personal)',
                    'slug' => Str::slug('Social Media Post (Personal)', '-'),
                    'description' => 'Write a social media post for yourself to be published on any platform.',
                    'toneable' => 1,
                    'status_id' => Status::findByNameAndType('status_active', 'template')->id,
                    'icon' => '',
                    'fields' => json_encode([
                        [
                            'level' => 'What is this post about?',
                            'key' => 'post_context',
                            'type' => 'textarea',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ]
                    ]),
                    'postfix' => 'Please write a social media post for myself to be published on any platform.'
                ],
                [
                    'category_id' => 5,
                    'name' => 'Social Media Post (Business)',
                    'slug' => Str::slug('Social Media Post (Business)', '-'),
                    'description' => 'Write a post for your business to be published on any social media platform.',
                    'toneable' => 1,
                    'status_id' => Status::findByNameAndType('status_active', 'template')->id,
                    'icon' => '',
                    'fields' => json_encode([
                        [
                            'level' => 'What is this post about?',
                            'key' => 'post_context',
                            'type' => 'textarea',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ]
                    ]),
                    'postfix' => 'Please write a social media post for my business to be published on any platform.'
                ],
                [
                    'category_id' => 6,
                    'name' => 'Video Titles',
                    'slug' => Str::slug('Video Titles', '-'),
                    'description' => 'Write a compelling YouTube video title to catch everyones attention.',
                    'toneable' => 0,
                    'status_id' => Status::findByNameAndType('status_active', 'template')->id,
                    'icon' => '',
                    'fields' => json_encode([
                        [
                            'level' => 'What is your video about?',
                            'key' => 'description',
                            'type' => 'textarea',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ]
                    ]),
                    'postfix' => 'Please make youtube video title list about this to catch everyones attention.'
                ],
                [
                    'category_id' => 6,
                    'name' => 'Video Descriptions',
                    'slug' => Str::slug('Video Descriptions', '-'),
                    'description' => 'Write compelling YouTube descriptions to get people interested in your video.',
                    'toneable' => 0,
                    'status_id' => Status::findByNameAndType('status_active', 'template')->id,
                    'icon' => '',
                    'fields' => json_encode([
                        [
                            'level' => 'What is your video about?',
                            'key' => 'description',
                            'type' => 'textarea',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ]
                    ]),
                    'postfix' => 'Please write a compelling YouTube video descriptions to get people interested in my video.'
                ],
                [
                    'category_id' => 6,
                    'name' => 'Video Scripts',
                    'slug' => Str::slug('Video Scripts', '-'),
                    'description' => 'Quickly create scripts for your videos and start shooting.',
                    'toneable' => 1,
                    'status_id' => Status::findByNameAndType('status_active', 'template')->id,
                    'icon' => '',
                    'fields' => json_encode([
                        [
                            'level' => 'What is your video about?',
                            'key' => 'description',
                            'type' => 'textarea',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ]
                    ]),
                    'postfix' => 'Please write a video script about given context.'
                ],
                [
                    'category_id' => 7,
                    'name' => 'Meta Description',
                    'slug' => Str::slug('Meta Description', '-'),
                    'description' => 'Write SEO-optimized meta description based on a description.',
                    'toneable' => 0,
                    'status_id' => Status::findByNameAndType('status_active', 'template')->id,
                    'icon' => '',
                    'fields' => json_encode([
                        [
                            'level' => 'Website Name',
                            'key' => 'website_name',
                            'type' => 'text',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ],
                        [
                            'level' => 'Website Description',
                            'key' => 'description',
                            'type' => 'textarea',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ],
                        [
                            'level' => 'Keywords',
                            'key' => 'keywords',
                            'type' => 'text',
                            'required' => false,
                            'placeholder' => 'Enter here'
                        ]
                    ]),
                    'postfix' => 'Please write SEO optimized meta description based on given details.'
                ],
                [
                    'category_id' => 7,
                    'name' => 'FAQs',
                    'slug' => Str::slug('FAQs', '-'),
                    'description' => 'Generate frequently asked questions based on your product description.',
                    'toneable' => 0,
                    'status_id' => Status::findByNameAndType('status_active', 'template')->id,
                    'icon' => '',
                    'fields' => json_encode([
                        [
                            'level' => 'Product Name',
                            'key' => 'product_name',
                            'type' => 'text',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ],
                        [
                            'level' => 'Product Description',
                            'key' => 'description',
                            'type' => 'textarea',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ]
                    ]),
                    'postfix' => 'Please make FAQs list about this.'
                ],
                [
                    'category_id' => 7,
                    'name' => 'FAQ Answers',
                    'slug' => Str::slug('FAQ Answers', '-'),
                    'description' => 'Generate creative answers to questions (FAQs) about your business or website.',
                    'toneable' => 0,
                    'status_id' => Status::findByNameAndType('status_active', 'template')->id,
                    'icon' => '',
                    'fields' => json_encode([
                        [
                            'level' => 'What is the question ',
                            'key' => 'question',
                            'type' => 'text',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ],
                        [
                            'level' => 'Product Name',
                            'key' => 'product_name',
                            'type' => 'text',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ],
                        [
                            'level' => 'Product Description',
                            'key' => 'description',
                            'type' => 'textarea',
                            'required' => true,
                            'placeholder' => 'Enter here'
                        ]
                    ]),
                    'postfix' => 'Please write FAQ\'s answer about given details.'
                ],
            ]
        );
    }
}
