<?php

namespace Database\Seeders\Application;

use App\Models\Application\AI\Category;
use App\Models\Core\Status;
use Illuminate\Database\Seeder;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Category::query()->truncate();

        Category::insert(
            [
                [
                    'id' => 1,
                    'name' => 'Blog',
                    'type' => 'template',
                    'status_id' => Status::findByNameAndType('status_active', 'category')->id
                ],
                [
                    'id' => 2,
                    'name' => 'Content',
                    'type' => 'template',
                    'status_id' => Status::findByNameAndType('status_active', 'category')->id
                ],
                [
                    'id' => 3,
                    'name' => 'Email',
                    'type' => 'template',
                    'status_id' => Status::findByNameAndType('status_active', 'category')->id
                ],
                [
                    'id' => 4,
                    'name' => 'Others',
                    'type' => 'template',
                    'status_id' => Status::findByNameAndType('status_active', 'category')->id
                ],

                [
                    'id' => 5,
                    'name' => 'Social Media',
                    'type' => 'template',
                    'status_id' => Status::findByNameAndType('status_active', 'category')->id
                ],
                [
                    'id' => 6,
                    'name' => 'Video',
                    'type' => 'template',
                    'status_id' => Status::findByNameAndType('status_active', 'category')->id
                ],
                [
                    'id' => 7,
                    'name' => 'Website',
                    'type' => 'template',
                    'status_id' => Status::findByNameAndType('status_active', 'category')->id
                ],
                [
                    'id' => 8,
                    'name' => 'Blog',
                    'type' => 'document',
                    'status_id' => Status::findByNameAndType('status_active', 'category')->id
                ],
                [
                    'id' => 9,
                    'name' => 'Content',
                    'type' => 'document',
                    'status_id' => Status::findByNameAndType('status_active', 'category')->id
                ],
                [
                    'id' => 10,
                    'name' => 'Email',
                    'type' => 'document',
                    'status_id' => Status::findByNameAndType('status_active', 'category')->id
                ],
                [
                    'id' => 11,
                    'name' => 'Others',
                    'type' => 'document',
                    'status_id' => Status::findByNameAndType('status_active', 'category')->id
                ],

                [
                    'id' => 12,
                    'name' => 'Social Media',
                    'type' => 'document',
                    'status_id' => Status::findByNameAndType('status_active', 'category')->id
                ],
                [
                    'id' => 13,
                    'name' => 'Video',
                    'type' => 'document',
                    'status_id' => Status::findByNameAndType('status_active', 'category')->id
                ],
                [
                    'id' => 14,
                    'name' => 'Website',
                    'type' => 'document',
                    'status_id' => Status::findByNameAndType('status_active', 'category')->id
                ],
            ]
        );
    }
}
