<?php
namespace Database\Seeders\Application;

use App\Models\Core\Auth\Permission;
use App\Models\Core\Auth\Role;
use App\Models\Core\Auth\Type;
use App\Models\Core\Auth\User;
use Illuminate\Database\Seeder;

class ApplicationPermissionRoleSeeder extends Seeder
{
    /**
     * Run the database seeders.
     *
     * @return void
     */
    public function run()
    {
        $superAdmin = User::first();
        $role = Role::firstOrCreate(
            [
                'name' => 'User',
            ],
            [
                'is_admin' => 0,
                'type_id' => Type::findByAlias('app')->id,
                'created_by' => $superAdmin->id,
                'is_default' => 0
            ]);

        $permissions = Permission::whereIn('name', $this->userPermissions())->pluck('id')->toArray();
        $role->permissions()->syncWithoutDetaching($permissions);
    }

    public function userPermissions() {
        return [
            'view_completion_overview',
            'view_document_overview',
        ];
    }
}
