<?php
namespace Database\Seeders\Application;

use App\Models\Core\Setting\Setting;
use Illuminate\Database\Seeder;

class AiSettingTableSeeder extends Seeder
{
    /**
     * Run the database seeders.
     *
     * @return void
     */
    public function run()
    {
        Setting::query()->where('context', 'open_ai')->delete();
        Setting::query()->insert(
            $this->getSeedEncryptAiData()
        );
    }

    public function getSeedEncryptAiData()
    {
        $open_ai_data_list = config('settings.open_ai');
        $seed_ai_data = [];
        foreach ($open_ai_data_list as $key => $open_ai_data) {
            if(env('MARKET_PLACE_VERSION', false)) {
                if($open_ai_data['name'] === 'open_ai_config') {
                    $open_ai_data['value'] = 1;
                }
            }
            $open_ai_data['value'] = encrypt($open_ai_data['value']);
            $seed_ai_data[] = $open_ai_data;
        }
        return $seed_ai_data;
    }
}
