<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ai_generated_files', function (Blueprint $table) {
            $table->id();
            $table->string('uuid', 80);
            $table->foreignId('user_id');
            $table->string('name');
            $table->string('type', 20)->default('image')->comment('image, audio, video, pdf');
            $table->longText('prompt');
            $table->string('path');
            $table->string('disk_type', 30);
            $table->string('mime_type', 60);
            $table->string('extension', 10);
            $table->integer('height')->nullable();
            $table->integer('width')->nullable();
            $table->integer('file_size_in_kb')->default(0);
            $table->json('meta_data')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ai_generated_files');
    }
};
