<?php

namespace Database\Factories;

use App\Repositories\Core\Status\StatusRepository;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\ExampleTable>
 */
class ExampleTableFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        $status = resolve(StatusRepository::class)->exampleActiveInactive();
        return [
            'name' => $this->faker->name(),
            'email' => $this->faker->unique()->safeEmail(),
            'phone_number' => $this->faker->phoneNumber(),
            'age' => $this->faker->randomNumber(2, true),
            'gender' => $this->faker->randomElement(['male', 'female', 'other']),
            'status_id' => $this->faker->randomElement($status),
        ];
    }
}
