<?php

namespace Database\Factories\Application\AI;

use Illuminate\Database\Eloquent\Factories\Factory;

class DocumentFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        $currentDateTime = date('Y-m-d H:i:s');
        $lastMonthDateTime = date('Y-m-01 H:i:s', strtotime('last month'));
        $randomDateTime = $this->faker->dateTimeBetween($lastMonthDateTime, $currentDateTime)->format('Y-m-d H:i:s');
        return [
            'user_id' => rand(1, 3),
            'category_id' => rand(8, 14),
            'name' => $this->faker->name,
            'content' => $this->faker->paragraph,
            'created_at' => $randomDateTime,
            'updated_at' => $randomDateTime,
        ];
    }
}
