<?php

namespace Database\Factories\Application\AI;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class CompletionFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        $currentDateTime = date('Y-m-d H:i:s');
        $lastMonthDateTime = date('Y-m-01 H:i:s', strtotime('last month'));
        $randomDateTime = $this->faker->dateTimeBetween($lastMonthDateTime, $currentDateTime)->format('Y-m-d H:i:s');
        $prompt_tokens = rand(100, 350);
        $completion_tokens = rand(100, 350);
        $total_tokens = ($prompt_tokens + $completion_tokens);
        return [
            'user_id' => rand(1, 3),
            'template_id' => rand(1, 20),
            'uuid' => Str::uuid(),
            'prompt_tokens' => $prompt_tokens,
            'completion_tokens' => $completion_tokens,
            'total_tokens' => $total_tokens,
            'created_at' => $randomDateTime,
            'updated_at' => $randomDateTime,
        ];
    }
}
