<?php

return [
    'user' => [
        ['name' => 'gender', 'value' => '', 'context' => 'user'],
        ['name' => 'contact', 'value' => '', 'context' => 'user'],
        ['name' => 'address', 'value' => '', 'context' => 'user'],
        ['name' => 'date_of_birth', 'value' => '', 'context' => 'user'],
    ],
    'open_ai' => [
        ['name' => 'open_ai_config', 'value' => '0', 'context' => 'open_ai'],
        ['name' => 'open_ai_key', 'value' => env('OPENAI_API_KEY'), 'context' => 'open_ai'],
        ['name' => 'default_openai_model', 'value' => env('OPENAI_MODEL', 'text-davinci-003'), 'context' => 'open_ai'],
        ['name' => 'open_ai_usage_limit', 'value' => env('OPENAI_USAGE_LIMIT', 10), 'context' => 'open_ai'],
        ['name' => 'open_ai_tokens_per_use', 'value' => env('OPENAI_TOKENS_PER_USE', 1000), 'context' => 'open_ai'],
        ['name' => 'default_openai_tone', 'value' => env('OPENAI_TONE', 'funny'), 'context' => 'open_ai'],
        ['name' => 'default_openai_creativity', 'value' => env('OPENAI_CREATIVITY', '0'), 'context' => 'open_ai'],
    ],
    'app' => [
        ['name' => 'company_name', 'value' => env('APP_NAME', 'Brain Box'), 'context' => 'app', 'autoload' => 0, 'public' => 1],
        ['name' => 'company_logo', 'value' => 'images/default-logo.svg', 'context' => 'app', 'autoload' => 0, 'public' => 1],
        ['name' => 'company_icon', 'value' => 'images/default-icon.svg', 'context' => 'app', 'autoload' => 0, 'public' => 1],
        ['name' => 'company_banner', 'value' => 'images/default-banner.png', 'context' => 'app', 'autoload' => 0, 'public' => 1],
        ['name' => 'language', 'value' => 'en', 'context' => 'app', 'autoload' => 0, 'public' => 1],
        ['name' => 'date_format', 'value' => 'd-m-Y', 'context' => 'app', 'autoload' => 0, 'public' => 1],
        ['name' => 'time_format', 'value' => 'h', 'context' => 'app', 'autoload' => 0, 'public' => 1],
        ['name' => 'time_zone', 'value' => 'Asia/Dhaka', 'context' => 'app', 'autoload' => 0, 'public' => 1],
        ['name' => 'currency_symbol', 'value' => '$', 'context' => 'app', 'autoload' => 0, 'public' => 1],
        ['name' => 'decimal_separator', 'value' => '.', 'context' => 'app', 'autoload' => 0, 'public' => 1],
        ['name' => 'thousand_separator', 'value' => ',', 'context' => 'app', 'autoload' => 0, 'public' => 1],
        ['name' => 'number_of_decimal', 'value' => '2', 'context' => 'app', 'autoload' => 0, 'public' => 1],
        ['name' => 'currency_position', 'value' => 'prefix_with_space', 'context' => 'app', 'autoload' => 0, 'public' => 1],
        ['name' => 'registration', 'value' => 0, 'context' => 'app', 'autoload' => 0, 'public' => 1],
    ],
    'brand' => [
        ['name' => 'avatar', 'value' => null, 'context' => 'brand'],
        ['name' => 'address', 'value' => '', 'context' => 'brand'],
    ],
    'context' => [
        'app',
        'campaign',
        'list',
        'user',
        'segment',
        'subscriber',
        'brand',
        'role',
        'template'
    ],
    'time_format' => [
        'h',
        'H'
    ],
    'registration' => [
        1,
        0
    ],
    'report_categories' => [
        ['id' => 'post', 'value' => 'Post'],
    ],
    'layouts' => [
        'ltr',
        'rtl'
    ],
    'currency_position' => [
        'prefix_only',
        'prefix_with_space',
        'suffix_only',
        'suffix_with_space'
    ],
    'amazon_ses' => [
        'hostname' => '',
        'access_key_id' => '',
        'secret_access_key' => '',
    ],
    'mailgun' => [
        'domain_name' => '',
        'api_key' => '',
        'webhook_key' => ''
    ],
    'mail_configs' => [
        'context' => '',
        'from_email' => '',
        'from_name' => ''
    ],
    'date_format' => [
        'd-m-Y',
        'm-d-Y',
        'Y-m-d',
        'm/d/Y',
        'd/m/Y',
        'Y/m/d',
        'm.d.Y',
        'd.m.Y',
        'Y.m.d'
    ],

    'decimal_separator' => [
        '.',
        ','
    ],

    'thousand_separator' => [
        '.',
        ',',
        ' '
    ],
    'number_of_decimal' => [
        '0',
        '2'
    ],
    'supported_mail_services' => [
        'amazon_ses' => 'Amazon SES',
        'mailgun' => 'Mailgun'
    ],
    'corn-job-context' => 'corn-job',
    'brand_default_prefix' => [
        'amazon_ses' => 'brand_default_amazon_ses',
        'mailgun' => 'brand_default_mailgun',
        'privacy' => 'brand_default_privacy',
        'notification' => 'brand_default_notification',
    ],

    'ai_models' => [
        'text-davinci-003' => 'Text Davinci 003',
        'text-davinci-002' => 'Text Davinci 002',
        'text-curie-001' => 'Text Curie 001',
        'text-babbage-001' => 'Text Babbage 001',
        'text-ada-001' => 'Text Ada 001',
    ],

    'tones' => [
        'funny' => 'Funny',
        'casual' => 'Casual',
        'excited' => 'Excited',
        'professional' => 'Professional',
        'witty' => 'Witty',
        'sarcastic' => 'Sarcastic',
        'feminine' => 'Feminine',
        'masculine' => 'Masculine',
        'bold' => 'Bold',
        'dramatic' => 'Dramatic',
        'grumpy' => 'Grumpy',
        'secretive' => 'Secretive'
    ], 
    
    'creativities' =>[
        '0' => 'Low',
        '0.5' => 'Average',
        '1' => 'High'
    ]
];
