<?php

namespace App\Services\Application\FacadeServices;

use App\Models\Application\AI\FavoriteTemplate;
use App\Interfaces\FavoriteTemplateInterface;
use App\Services\Core\BaseService;
use Illuminate\Support\Facades\Auth;

class FavoriteTemplateFacadeService extends BaseService implements FavoriteTemplateInterface
{

    public function __construct(FavoriteTemplate $template)
    {
        $this->model = $template;
    }
    
    public function index()
    {
        return FavoriteTemplate::where(['user_id' => Auth::id()])->get();
    }

    public function store(array $request)
    {
        try {
            $model = FavoriteTemplate::where(['user_id' => Auth::id(), 'template_id' => $request['template_id']])->first();
            $message = '';
            if ($model) {
                $model->delete();
                $message = __t('favorite_template_remove');
            } else {
                FavoriteTemplate::create(['user_id' => Auth::id(), 'template_id' => $request['template_id']]);
                $message = __t('favorite_template_add');
            }

            return $message;
        } catch (\Exception $ex) {
            return throw new \Exception($ex->getMessage());
        }
    }

}
