<?php

namespace App\Services\Application\FacadeServices;

use App\Filters\Application\AI\DocumentFilter;
use App\Models\Application\AI\Document;
use App\Interfaces\DocumentInterface;
use App\Services\Core\BaseService;
use Illuminate\Support\Facades\Auth;

class DocumentFacadeService extends BaseService implements DocumentInterface
{
    public function __construct(Document $document)
    {
        $this->model = $document;
    }

    public function index()
    {
        return $this->model->filters(new DocumentFilter)->with('category:id,name')
            ->where('user_id', Auth::id())
            ->orderBy('id', 'DESC')
            ->paginate(request()->get('per_page', 10));
    }

    public function store(array $request)
    {
        try {
            return $this->setAttributes(array_merge($request, ['user_id' => Auth::id()]))->save();
        } catch (\Exception $e) {
            return throw new \Exception($e->getMessage());
        }
    }

    public function update(int $id, array $request)
    {
        try {
            return $this->find($id)->update($request);
        } catch (\Exception $e) {
            return throw new \Exception($e->getMessage());
        }
    }

    public function destroy(int $id)
    {
        try {
            return $this->model->find($id)->delete();
        } catch (\Exception $e) {
            return throw new \Exception($e->getMessage());
        }
    }
}
