<?php

namespace App\Services\Application\FacadeServices;

use App\Interfaces\CategoryInterface;
use App\Models\Application\AI\Category;
use App\Models\Core\Status;
use App\Services\Core\BaseService;

class CategoryFacadeService extends BaseService implements CategoryInterface
{

    public function __construct(Category $category)
    {
        $this->model = $category;
    }

    public function getByType(string $type = "template")
    {
        return Category::where(['type' => $type, 'status_id' => Status::findByNameAndType('status_active', 'category')->id])->get();
    }
}
