<?php

namespace App\Providers;

use App\Services\Application\FacadeServices\CategoryFacadeService;
use App\Services\Application\FacadeServices\CompletionFacadeService;
use App\Services\Application\FacadeServices\DocumentFacadeService;
use App\Services\Application\FacadeServices\FavoriteTemplateFacadeService;
use App\Services\Application\FacadeServices\JsonResponseFacadeService;
use App\Services\Application\FacadeServices\TemplateFacadeService;
use App\Services\Core\Auth\UserCreateService;
use Illuminate\Support\ServiceProvider;

class FacadeServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->bind('template-facade-service', function ($app) {
            return $app->make(TemplateFacadeService::class);
        });

        $this->app->bind('completion-facade-service', function ($app) {
            return $app->make(CompletionFacadeService::class);
        });

        $this->app->bind('document-facade-service', function ($app) {
            return $app->make(DocumentFacadeService::class);
        });

        $this->app->bind('favorite-template-facade-service', function ($app) {
            return $app->make(FavoriteTemplateFacadeService::class);
        });

        $this->app->bind('json-response-facade-service', function ($app) {
            return $app->make(JsonResponseFacadeService::class);
        });

        $this->app->bind('user-create-facade-service', function ($app) {
            return $app->make(UserCreateService::class);
        });

        $this->app->bind('category-facade-service', function ($app) {
            return $app->make(CategoryFacadeService::class);
        });

        // Register more  facade services.
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
    }
}
