<?php

namespace App\Providers;

use App\Helpers\Config\SetAiConfig;
use App\Helpers\Config\SetBroadcastingConfig;
use App\Helpers\Config\SetMailConfig;
use App\Helpers\Config\SetSettingsConfig;
use Carbon\Carbon;
use Exception;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    public function register()
    {

    }


    public function boot()
    {
        Schema::defaultStringLength(191);
        Paginator::useBootstrap();

        setlocale(LC_TIME, config('app.locale_php'));

        Carbon::setLocale(config('app.locale'));


        if (! app()->runningInConsole()) {
            if (config('locale.languages')[config('app.locale')][2]) {
                session(['lang-rtl' => true]);
            } else {
                session()->forget('lang-rtl');
            }
        }

        try {
            SetMailConfig::new(true)
                ->clear()
                ->set();

            SetBroadcastingConfig::new(true)
                ->cashClear()
                ->configSet();

            SetAiConfig::new(true)
                ->cacheClear()
                ->configSet();

            SetSettingsConfig::new(true)
                ->set();

        } catch (Exception $exception){
            return $exception;
        }
    }
}
