<?php

namespace App\Mail\Core\User;

use App\Mail\Tag\UserTag;
use App\Models\Core\Auth\User;
use App\Notifications\Core\Helper\NotificationTemplateHelper;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class UserRegistrationMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;


    protected $user;
    protected $token;

    public function __construct(User $user, $token)
    {
        $this->user = $user;
        $this->token = $token;

    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $template = $this->template();

        $tag = new UserTag($this->user);

        return $this->view('notification.mail.user.template', [
            'template' => $template->parse(
                $tag->emailVerify($this->token)
            )
        ])->subject($template->parseSubject(
            method_exists($tag, 'emailVerifySubject') ? $tag->emailVerifySubject() : ['{name}' => $this->user->full_name]
        ));
    }


    public function template()
    {
        return NotificationTemplateHelper::new()
            ->on('user_registered')
            ->mail();
    }

}
