<?php

namespace App\Http\Requests\Core\Auth\User;

use App\Http\Requests\BaseRequest;
use App\Models\Core\Auth\User;
use Illuminate\Validation\Rule;

class UserRoleRequest extends BaseRequest
{
    protected function prepareForValidation()
    {
        if ($this->has('roles')) {
            $roles = is_array($this->get('roles')) ? $this->get('roles') : [$this->get('roles')];
            $this->merge([
                'roles' => $roles
            ]);
        }
    }
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     * @throws \App\Exceptions\GeneralException
     */
    public function rules()
    {
        return [
            'roles' => [
                'required',
                'array',
                Rule::exists('roles', 'id')->where(function ($query) {
                    $query->whereIn('id', $this->roles);
                })
            ],
        ];
    }
}
