<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AiRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'open_ai_config' => ['required', 'boolean'],
            'open_ai_key' => ['required_if:open_ai_config,==,1', 'nullable','string'],
            'open_ai_usage_limit' => ['required_if:open_ai_config,==,1', 'nullable','integer', 'max:500'],
            'open_ai_tokens_per_use' => ['required_if:open_ai_config,==,1', 'nullable','integer', 'max:8190'],
            'default_openai_model' => ['required_if:open_ai_config,==,1', 'nullable','string'],
            'default_openai_tone' => ['required_if:open_ai_config,==,1', 'nullable','string'],
            'default_openai_creativity' => ['required_if:open_ai_config,==,1', 'nullable','string'],
        ];
    }

    public function messages()
    {
        return [
            'open_ai_config.required' => 'Must select enable or disable',
            'open_ai_key.required_if' => 'OpenAI Key is required',
            'open_ai_usage_limit.required_if' => 'OpenAI usage limit is required',
            'open_ai_tokens_per_use.required_if' => 'OpenAI usable token limit is required',
            'default_openai_model.required_if' => 'Must select a model',
            'default_openai_tone.required_if' => 'Must select a default tone',
            'default_openai_creativity.required_if' => 'Please select creativity level of OpenAI',
        ];
    }
}
