<?php

namespace App\Http\Controllers\Core\Auth;

use App\Hooks\User\AfterUserConfirmed;
use App\Hooks\User\AfterUserInvited;
use App\Hooks\User\BeforeUserInvited;
use App\Http\Controllers\Controller;
use App\Facades\UserCreateFacade;
use App\Http\Requests\Core\Auth\User\UserCreateRequest;
use Illuminate\Support\Facades\DB;
class UserCreateController extends Controller
{

    /**
     * @var BeforeUserInvited
     */
    private $beforeUserInvited;

    /**
     * @var AfterUserInvited
     */
    private $afterUserInvited;

    public function __construct(BeforeUserInvited $beforeUserInvited, AfterUserInvited $afterUserInvited)
    {
        $this->beforeUserInvited = $beforeUserInvited;
        $this->afterUserInvited = $afterUserInvited;
    }

    public function create(UserCreateRequest $request)
    {
        DB::transaction(function () use ($request) {
            $this->beforeUserInvited
                ->handle();

            $user = UserCreateFacade::setAttributes($request->only('first_name', 'last_name', 'email', 'roles'))
                ->validateMailSettings()
                ->create();

            $this->afterUserInvited
                ->setModel($user)
                ->cacheQueueClear();

            AfterUserConfirmed::new()
                ->setModel($user)
                ->handle();
        });

        return response()->json([
            'status' => true,
            'message' => trans('default.create_user_response')
        ]);
    }
}